<?php
// doopSites v1.9.7 - Última atualização 05/09/2023 11:12

require_once(config('app.ROOT_CMS_CORE').'/class.controller.php');

class SubmoduleDoop extends ControllerDoop
{
    public $active = null;
    public $quantity = 200;
    public $dataSubmodule = null;
    public $newPath = null;
    public $config = [
        'seo' => [
            'title' => null,
            'description' => null,
            'keywords' => null
        ],
        'scripts' => [
            'head_inicio' => null,
            'head_final' => null,
            'body_inicio' => null,
            'body_final' => null
        ]
    ];

    public $dimensions = [800, 600];

    public function __construct($key = null, $path = null, $params = null)
    {
        parent::__construct($key, 'manage', 'extra');

        if ($params) {
            $this->dataSubmodule = $params;
        }

        $this->active = $key;

        $this->modules->extra = '#'.$this->active;

        $this->setTable('sub_'.$this->active);
        $this->setSufix($this->active);

        $this->setNewPath($path);

        $this->modules->control['bt_update'] = false;

        if ($this->post('updateAll_'.$this->active)) {
            $this->sub_update();
        }

        if ($this->get('action') == 'set_deleted') {
            $this->sub_delete($this->active);
        }

        if ($this->get('action') == 'deleteAllItens') {
            $this->sub_delete_all($this->active);
        }
    }

    public function sub_insert()
    {
        $this->modules->operation = 'insert';

        if ($this->active === 'photo') {
            $upload = new \CoreSlim\Upload();
            $upload->config($this->sufix('file'), $this->dataSubmodule['folder'], $this->newPath);
            $upload->setConfig('multiple', true);
            $upload->dimensions($this->dimensions);
            $upload->load(true);

            if ($output = $upload->output('array')) {
                foreach ($output as $key => $fileReturn) {
                    if (!isset($fileReturn['legend'])) {
                        $legend = null;
                    }
                    else {
                        $legend = str_replace('.'.$fileReturn['extension'], '', $fileReturn['legend']);
                    }

                    $data = [
                        $this->sufix('table') => $this->dataSubmodule['table'],
                        $this->sufix('tuple') => $this->dataSubmodule['tuple'],
                        $this->sufix('file') => json_encode($fileReturn),
                        $this->sufix('legend') => $legend,
                        $this->sufix('credit') => null,
                        $this->sufix('order') => $this->generatorOrder("AND `".$this->sufix('table')."` = '".$this->dataSubmodule['table']."' AND `".$this->sufix('tuple')."` = '".$this->dataSubmodule['tuple']."'")
                    ];

                    $this->dataSave($data, 'insert');
                }
            }

            header('Location: '.$this->modules->pathlang(null, $this->newPath.'&callback=304').'#photo');
            exit;
        }
        else if ($this->active === 'video') {
            $url = $this->post($this->sufix('url'), 'array_explode');
            $legend = $this->post($this->sufix('legend'), 'array_explode');
            $credit = $this->post($this->sufix('credit'), 'array_explode');

            foreach ($url as $key => $value) {
                $video = $this->setVideo($value);

                if ($video != null) {
                    $data = [
                        $this->sufix('table') => $this->dataSubmodule['table'],
                        $this->sufix('tuple') => $this->dataSubmodule['tuple'],
                        $this->sufix('tag') => $video,
                        $this->sufix('legend') => $this->processData($legend[$key], 'text'),
                        $this->sufix('order') => $this->generatorOrder("AND `".$this->sufix('table')."` = '".$this->dataSubmodule['table']."' AND `".$this->sufix('tuple')."` = '".$this->dataSubmodule['tuple']."'")
                    ];

                    if (isset($credit[$key])) {
                        $data[$this->sufix('credit')] = $this->processData($credit[$key], 'text');
                    }

                    $this->dataSave($data, 'insert');
                }
                else {
                    header('Location: '.$this->newPath.'&callback=504#video');
                    exit;
                }
            }

            header('Location: '.$this->newPath.'&callback=306#video');
            exit;
        }
        else if ($this->active === 'anexx') {
            $upload = new \CoreSlim\Upload();
            $upload->config($this->sufix('file'), $this->dataSubmodule['folder'], $this->newPath);
            $upload->setConfig('multiple', true);
            $upload->setConfig('type', 'annex');
            $upload->load(true);

            if ($output = $upload->output('array')) {
                foreach ($output as $key => $fileReturn) {
                    $data = [
                        $this->sufix('table') => $this->dataSubmodule['table'],
                        $this->sufix('tuple') => $this->dataSubmodule['tuple'],
                        $this->sufix('file') => json_encode($fileReturn),
                        $this->sufix('order') => $this->generatorOrder("AND `".$this->sufix('table')."` = '".$this->dataSubmodule['table']."' AND `".$this->sufix('tuple')."` = '".$this->dataSubmodule['tuple']."'")
                    ];

                    $this->dataSave($data, 'insert');
                }
            }

            header('Location: '.$this->newPath.'&callback=308#anexx');
            exit;
        }
        else if ($this->active === 'audio') {
            $upload = new \CoreSlim\Upload();
            $upload->config($this->sufix('file'), $this->dataSubmodule['folder'], $this->newPath);
            $upload->setConfig('multiple', true);
            $upload->setConfig('type', 'audio');
            $upload->load(true);

            if ($output = $upload->output('array')) {
                foreach ($output as $key => $fileReturn) {
                    $data = [
                        $this->sufix('table') => $this->dataSubmodule['table'],
                        $this->sufix('tuple') => $this->dataSubmodule['tuple'],
                        $this->sufix('file') =>  json_encode($fileReturn),
                        $this->sufix('order') => $this->generatorOrder("AND `".$this->sufix('table')."` = '".$this->dataSubmodule['table']."' AND `".$this->sufix('tuple')."` = '".$this->dataSubmodule['tuple']."'")
                    ];

                    $this->dataSave($data, 'insert');
                }
            }

            header('Location: '.$this->newPath.'&callback=310#audio');
            exit;
        }
    }

    public function sub_update()
    {
        $this->modules->operation = 'update';

        if ($this->active != 'config') {
            $dataMultiple = $_POST;
            $dataTreat = null;

            //array_shift($dataMultiple);

            foreach ($dataMultiple as $key => $value) {
                $explode = explode('_', $key);

                if (isset($explode[2])) {
                    $dataTreat[$explode[2]][$explode[0].'_'.$explode[1]] = $value;
                }
            }
        }

        if ($this->active == 'photo') {
            foreach($dataTreat as $key => $value) {
                $data = [
                    $this->sufix('legend') => $this->processData($value[$this->sufix('legend')], 'text'),
                    $this->sufix('credit') => $this->processData($value[$this->sufix('credit')], 'text'),
                    $this->sufix('order') => $this->processData($value[$this->sufix('order')])
                ];

                $this->setValue($key);
                $this->setTuplePrimary('id');
                $this->dataSave($data, 'update');
            }

            header('Location: '.$this->newPath.'&callback=305#photo');
            exit;
        }
        else if ($this->active == 'video') {
            foreach ($dataTreat as $key => $value) {
                $data = [
                    $this->sufix('legend') => $this->processData($value[$this->sufix('legend')], 'text'),
                    $this->sufix('credit') => $this->processData($value[$this->sufix('credit')], 'text'),
                    $this->sufix('order') => $this->processData($value[$this->sufix('order')])
                ];

                $this->setValue($key);
                $this->setTuplePrimary('id');
                $this->dataSave($data, 'update');
            }

            header('Location: '.$this->newPath.'&callback=307#video');
            exit;
        }
        else if ($this->active == 'anexx') {
            foreach ($dataTreat as $key => $value) {
                $data = [
                    $this->sufix('legend') => $this->processData($value[$this->sufix('legend')]),
                    $this->sufix('order') => $this->processData($value[$this->sufix('order')])
                ];

                $this->setValue($key);
                $this->setTuplePrimary('id');
                $this->dataSave($data, 'update');
            }

            header('Location: '.$this->newPath.'&callback=309#anexx');
            exit;
        }
        else if ($this->active == 'audio') {
            foreach($dataTreat as $key => $value) {
                $data =[$this->sufix('legend') => $this->processData($value[$this->sufix('legend')]),
                        $this->sufix('order') => $this->processData($value[$this->sufix('order')])];

                $this->setValue($key);
                $this->setTuplePrimary('id');
                $this->dataSave($data, 'update');
            }

            header('Location: '.$this->newPath.'&callback=311#audio');
            exit;
        }
        else if ($this->active == 'config') {
            $seo['title'] = $this->post($this->sufix('seo_title'));
            $seo['description'] = $this->post($this->sufix('seo_description'));
            $seo['keywords'] = $this->post($this->sufix('seo_keywords'));

            $scripts['head_inicio'] = $this->post($this->sufix('scripts_head_inicio'), 'code');
            $scripts['head_final'] = $this->post($this->sufix('scripts_head_final'), 'code');
            $scripts['body_inicio'] = $this->post($this->sufix('scripts_body_inicio'), 'code');
            $scripts['body_final'] = $this->post($this->sufix('scripts_body_final'), 'code');

            $data = [
                $this->sufix('table') => $this->dataSubmodule['table'],
                $this->sufix('tuple') => $this->dataSubmodule['tuple'],
                $this->sufix('seo') => json_encode($seo),
                $this->sufix('scripts') => json_encode($scripts)
            ];

            $query = "SELECT `id_config` FROM `sub_config` WHERE `table_config` = '".$this->dataSubmodule['table']."' AND `tuple_config` = '".$this->dataSubmodule['tuple']."'";

            if ($result = $this->dbFetch($query)) {
                $this->setValue($result[0]);
                $this->setTuplePrimary('id');
                $this->dataSave($data, 'update');
            }
            else {
                $this->dataSave($data, 'insert');
            }

            header('Location: '.$this->newPath.'&callback=312#config');
            exit;
        }
    }

    public function sub_delete($keyModule)
    {
        if ($this->get($keyModule)) {
            if ($keyModule == 'photo') {
                $query = "SELECT `".$this->sufix('id')."` as id, `".$this->sufix('file')."` as file
                          FROM `".$this->getTable()."`
                          WHERE  `".$this->sufix('uuid')."` = '".$this->get($keyModule)."'";

                $result = $this->dbFetchAssoc($query);

                $paths[] = config('app.ROOT_UPLOAD').'/'.$this->dataSubmodule['folder'].'/images/larger';
                $paths[] = config('app.ROOT_UPLOAD').'/'.$this->dataSubmodule['folder'].'/images/smaller';
                $paths[] = config('app.ROOT_UPLOAD').'/'.$this->dataSubmodule['folder'].'/images/temp';
            }
            else if ($keyModule == 'anexx' || $keyModule == 'audio') {
                $query = "SELECT `".$this->sufix('id')."` as id, `".$this->sufix('file')."` as file
                          FROM `".$this->getTable()."`
                          WHERE `".$this->sufix('uuid')."` = '".$this->get($keyModule)."'";

                $result = $this->dbFetchAssoc($query);

                $paths[] = config('app.ROOT_UPLOAD').'/'.$this->dataSubmodule['folder'].'/files';
            }

            if ($keyModule == 'photo' || $keyModule == 'anexx' || $keyModule == 'audio') {
                $file = json_decode($result['file'], true);

                $this->deleteFile($paths, $file['name']);
            }

            $this->dataDelete($this->get($keyModule));

            if ($keyModule == 'photo') {
                $callback = 313;
            }
            else if ($keyModule == 'video') {
                $callback = 314;
            }
            else if ($keyModule == 'anexx') {
                $callback = 316;
            }
            else if ($keyModule == 'audio') {
                $callback = 317;
            }

            header('Location: '.$this->newPath.'&callback='.$callback.'#'.$keyModule);
            exit;
        }
    }

    public function sub_delete_all($keyModule)
    {
        if ($this->get($keyModule)) {
            if ($keyModule == 'photo') {
                $query = "SELECT `".$this->sufix('id')."` as id, `".$this->sufix('uuid')."` as uuid, `".$this->sufix('file')."` as file FROM `".$this->getTable()."` WHERE  `".$this->sufix('table')."` = '".$this->dataSubmodule['table']."' AND `".$this->sufix('tuple')."` = '".$this->dataSubmodule['tuple']."'";

                $result = $this->dbFetchAll($query);

                $paths[] = config('app.ROOT_UPLOAD').'/'.$this->dataSubmodule['folder'].'/images/larger';
                $paths[] = config('app.ROOT_UPLOAD').'/'.$this->dataSubmodule['folder'].'/images/smaller';
                $paths[] = config('app.ROOT_UPLOAD').'/'.$this->dataSubmodule['folder'].'/images/temp';
            }
            else if ($keyModule == 'anexx' || $keyModule == 'audio') {
                $query = "SELECT `".$this->sufix('id')."` as id, `".$this->sufix('uuid')."` as uuid, `".$this->sufix('file')."` as file FROM `".$this->getTable()."` WHERE  `".$this->sufix('table')."` = '".$this->dataSubmodule['table']."' AND `".$this->sufix('tuple')."` = '".$this->dataSubmodule['tuple']."'";

                $result = $this->dbFetchAll($query);

                $paths[] = config('app.ROOT_UPLOAD').'/'.$this->dataSubmodule['folder'].'/files';
            }

            if ($keyModule == 'photo' || $keyModule == 'anexx' || $keyModule == 'audio') {
                foreach ($result as $key => $value) {
                    $file = json_decode($value['file'], true);

                    $this->deleteFile($paths, $file['name']);
                    $this->dataDelete($value['uuid']);
                }
            }

            if ($keyModule == 'video') {
                $query = "SELECT `".$this->sufix('id')."` as id, `".$this->sufix('uuid')."` as uuid FROM `".$this->getTable()."` WHERE  `".$this->sufix('table')."` = '".$this->dataSubmodule['table']."' AND `".$this->sufix('tuple')."` = '".$this->dataSubmodule['tuple']."'";

                $result = $this->dbFetchAll($query);

                foreach ($result as $key => $value) {
                    $this->dataDelete($value['uuid']);
                }
            }

            if ($keyModule == 'photo') {
                $callback = 318;
            }
            else if ($keyModule == 'video') {
                $callback = 319;
            }
            else if ($keyModule == 'anexx') {
                $callback = 320;
            }
            else if ($keyModule == 'audio') {
                $callback = 321;
            }

            header('Location: '.$this->newPath.'&callback='.$callback.'#'.$this->active);
            exit;
        }
    }

    public function setVideo($url)
    {
        $data = null;

        if (strpos($url, 'youtube.com')) {
            $url = parse_url($url);

            $vid = parse_str($url['query'], $output);

            $id_video = $output['v'];

            $data['type'] = 'youtube';
            $data['code'] = $id_video;

            if (isset($output['list'])) {
                $data['list'] = $output['list'];
            }

            if (isset($output['index'])) {
                $data['index'] = $output['index'];
            }
        }
        else if (strpos($url, 'vimeo.com')) {
            $id_video = explode('vimeo.com/', $url);
            $id_video = $id_video[1];

            $data['type'] = 'vimeo';
            $data['code'] = $id_video;
        }

        if (is_array($data)) {
            $data = json_encode($data);
        }

        return $data;
    }

    public function setNewPath($path)
    {
        $this->newPath = $path;

        $this->modules->page['insert']['path'] = $path;
        $this->modules->page['update']['path'] = $path;
        $this->modules->page['delete']['path'] = $path;
        $this->modules->page['manage']['path'] = $path;

        $this->modules->page['insert']['privilege'] = 'group';
        $this->modules->page['update']['privilege'] = 'group';
        $this->modules->page['delete']['privilege'] = 'group';
        $this->modules->page['manage']['privilege'] = 'group';
    }

    public function getVideoSub($parameter, $unique = false, $view = false)
    {
        $dataReturn = null;

        if (@json_encode($parameter)) {
            $parameter = json_decode($parameter, true);
        }

        if (!$view) {
            if ($unique) {
                $colorbox = 'data-toggle="lightbox"';
            }
            else {
                $colorbox = 'data-toggle="lightbox" data-gallery="gallery-videos-'.$this->dataSubmodule['folder'].'"';
            }

            $urlLink = 'https://www.youtube.com/embed/'.$parameter['code'];
            $urlEmbed = '//www.youtube.com/embed/'.$parameter['code'];

            if (isset($parameter['list'])) {
                $urlLink = 'https://www.youtube.com/embed/videoseries?list='.$parameter['list'];
                $urlEmbed = '//www.youtube.com/embed/videoseries?list='.$parameter['list'];

                if (isset($parameter['index'])) {
                    $urlLink = $urlLink.'&index='.$parameter['index'];
                    $urlEmbed = $urlEmbed.'&index='.$parameter['index'];
                }
            }

            if ($parameter['type'] == 'youtube') {
                $dataReturn = '<a href="'.$urlEmbed.'" '.$colorbox.' data-remote="'.$urlEmbed.'" data-type="youtube" data-width="800"><img src="https://i1.ytimg.com/vi/'.$parameter['code'].'/1.jpg" height="80" alt="" /></a>';
            }
            else if ($parameter['type'] == 'vimeo') {
                $hash = unserialize(file_get_contents("https://vimeo.com/api/v2/video/".$parameter['code'].".php"));

                $dataReturn = '<a href="https://player.vimeo.com/video/'.$parameter['code'].'?badge=0&amp;color=ffffff" '.$colorbox.' data-remote="'.$urlEmbed.' data-width="800" data-type="vimeo"><img src="'.$hash[0]['thumbnail_medium'].'" height="80" alt="" /></a>';
            }
        }
        else {
            if ($parameter['type'] == 'youtube') {
                $dataReturn = '<iframe width="500" height="300" src="'.$urlEmbed.'" frameborder="0" allowfullscreen></iframe>';
            }
            else if ($parameter['type'] == 'vimeo') {
                $dataReturn = '<iframe src="//player.vimeo.com/video/'.$parameter['code'].'?badge=0&amp;color=ffffff" width="500" height="300" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>';
            }
        }

        return $dataReturn;
    }

    public function getPhotoSub($parameter, $legend, $credit, $unique = false)
    {
        if ($unique) {
            $colorbox = 'data-toggle="lightbox"';
        }
        else {
            $colorbox = 'data-toggle="lightbox" data-type="image" data-width="800" data-gallery="gallery-photos-'.$this->dataSubmodule['folder'].'"';
        }

        $colorbox .= ' data-footer="';

        if ($legend) {
            $colorbox .= $legend;
        }

        if ($credit) {
            $colorbox .= ' - Crédito: '.$credit;
        }

        $pathLarger = Assets::loadThumb($parameter, $this->dataSubmodule['folder'], 'larger');
        $pathSmaller = Assets::loadThumb($parameter, $this->dataSubmodule['folder'], 'smaller');

        if (isset($pathLarger['image']['src'])) {
            $pathLargerView = $pathLarger['image']['src'];
        }

        if (isset($pathSmaller['image']['src'])) {
            $pathSmallerView = $pathSmaller['image']['src'];
        }

        $colorbox .= '"';

        return '<a href="'.$pathLargerView.'" '.$colorbox.' title="Visualizar">
                    <img src="'.$pathSmallerView.'" height="50" alt="Visualizar imagem" />
                </a>';
    }

    public function getPhotoSubDownload($data)
    {
        if (isset($data[$this->modules->sufix('file')])) {
            if (@json_decode($data[$this->modules->sufix('file')])) {
                $jsonData = json_decode($data[$this->modules->sufix('file')], true);
                $jsonData['realname'] = $this->processString($jsonData['realname']);

                $parameter = $jsonData['name'];
            }
        }

        $jsonData['root'] = config('app.ROOT_UPLOAD').'/'.$this->dataSubmodule['folder'].'/images/larger/'.$parameter;
        $jsonData['download'] = config('app.PATH_UPLOAD').'/'.$this->dataSubmodule['folder'].'/images/larger/'.$parameter;

        $jsonData['inTable'] = 'sub_photo';
        $jsonData['inSufix'] = 'photo';
        $jsonData['id'] = intval($data[$this->modules->sufix('id')]);
        $jsonData['table'] = $data[$this->modules->sufix('table')];
        $jsonData['tuple'] = intval($data[$this->modules->sufix('tuple')]);

        return '<a class="btn btn-sm btn-default" href="'.config('app.PATH_API').'/getDownload.php?parameter='.base64_encode(json_encode($jsonData)).'" title="Download"><i class="fa fa-download"></i></a>';
    }

    public function getAnexxSub($data)
    {
        if (isset($data[$this->modules->sufix('file')])) {
            if (@json_decode($data[$this->modules->sufix('file')])) {
                $jsonData = json_decode($data[$this->modules->sufix('file')], true);
                $jsonData['realname'] = $this->processString($jsonData['realname']);

                $parameter = $jsonData['name'];
            }

            $jsonData['root'] = config('app.ROOT_UPLOAD').'/'.$this->dataSubmodule['folder'].'/files/'.$parameter;
            $jsonData['download'] = config('app.PATH_UPLOAD').'/'.$this->dataSubmodule['folder'].'/files/'.$parameter;

            $jsonData['inTable'] = 'sub_anexx';
            $jsonData['inSufix'] = 'anexx';
            $jsonData['id'] = intval($data[$this->modules->sufix('id')]);
            $jsonData['table'] = $data[$this->modules->sufix('table')];
            $jsonData['tuple'] = intval($data[$this->modules->sufix('tuple')]);

            return '<a class="blue" href="'.config('app.PATH_API').'/getDownload.php?parameter='.base64_encode(json_encode($jsonData)).'" title="Download"><i class="fa fa-download bigger-130"></i></a>';
        }
    }

    public function getAudioSub($parameter)
    {
        if (@json_encode($parameter)) {
            $jsonData = json_decode($parameter, true);

            $parameter = $jsonData['name'];
        }

        return '<audio src="'.config('app.PATH_UPLOAD').'/'.$this->dataSubmodule['folder'].'/audios/'.$parameter.'" controls></audio>';
    }

    public function loadUnique()
    {
        $this->modules->dataUpdate = $this->modules->dataLoad($this->get($this->active));
    }

    public function loadDataConfig()
    {
        $query = "SELECT `seo_config`, `auths_config`, `scripts_config` FROM `sub_config` WHERE `table_config` = '".$this->dataSubmodule['table']."' AND `tuple_config` = '".$this->dataSubmodule['tuple']."'";

        if ($result = $this->dbFetch($query)) {
            if (isset($result['seo_config']) && @json_decode($result['seo_config'])) {
                $seo = json_decode($result['seo_config'], true);

                $this->config['seo']['title'] = $this->processString($seo['title']);
                $this->config['seo']['description'] = $this->processString($seo['description']);
                $this->config['seo']['keywords'] = $this->processString($seo['keywords']);
            }

            if (isset($result['scripts_config']) && @json_decode($result['scripts_config'])) {
                $scripts = json_decode($result['scripts_config'], true);

                $this->config['scripts']['head_inicio'] = $this->processString($scripts['head_inicio'], 'code');
                $this->config['scripts']['head_final'] = $this->processString($scripts['head_final'], 'code');
                $this->config['scripts']['body_inicio'] = $this->processString($scripts['body_inicio'], 'code');
                $this->config['scripts']['body_final'] = $this->processString($scripts['body_final'], 'code');
            }
        }
    }
}
