<?php
// doopSites v1.9.7 - Última atualização 22/02/2023 16:20

class HelpersDoop extends FunctionsDoop
{
    private $instance = null;

    private $hash = null;

    private $scope = [
        'table' => null,
        'sufix' => null
    ];

    private $data = null;

    private $urlCallback = null;

    public function __construct()
    {
        parent::__construct('system');

        $this->setDatabase();
    }

    public function setInstance($instance)
    {
        $this->instance = intval($instance);
    }

    public function getInstance()
    {
        return $this->instance;
    }

    public function setHash($hash)
    {
        $this->hash = $hash;
    }

    public function getHash()
    {
        return $this->hash;
    }

    public function setScope($type, $value)
    {
        $this->scope[$type] = $value;
    }

    public function getScope($type)
    {
        return $this->scope[$type];
    }

    public function setData($data)
    {
        $this->data = $data;
    }

    public function getData($type)
    {
        if (array_key_exists($type, $this->data)) {
            return $this->data[$type];
        }
    }

    public function setUrlCallback($urlCallback)
    {
        $this->urlCallback = $urlCallback;
    }

    public function getUrlCallback()
    {
        return $this->urlCallback;
    }

    public function getAction($action, $actionValue = true)
    {
        return $this->getUrlCallback().'&'.$action.'='.$actionValue.'#'.$this->getHash();
    }

    public function getActionCallback($callbackCode)
    {
        return $this->getUrlCallback().'&callback='.$callbackCode.'#'.$this->getHash();
    }

    public function setDatabase($table = null, $sufix = null)
    {
        if (is_null($table)) {
            $table = $this->getScope('table');
        }

        if (is_null($sufix)) {
            $sufix = $this->getScope('sufix');
        }

        parent::setTable($table);
        parent::setSufix($sufix);
    }
}
