<?php
// doopSites v1.9.7 - Última atualização 22/02/2023 16:20

require_once(config('app.ROOT_CMS_CORE').'/class.callback.php');
require_once(config('app.ROOT_CMS_CORE').'/class.model.php');

class FunctionsDoop extends ModelDoop
{
    public $callback = null;
    public $lang = 'pt_BR';
    public $langBreadcrumb = null;
    public $language = [];

    public function __construct($key = null)
    {
        $this->existsLang();

        parent::__construct($this, $this->lang());

        $this->setLang();

        $this->callback = new CallbackDoop($this->get('callback'));
    }

    public function lang()
    {
        return $this->lang;
    }

    public function setLang()
    {
        $this->lang = 'pt_BR';

        $lang = $this->getBaseData('pageLanguage');

        if ($lang) {
            $langtitle = $lang['langtitle'];
            $langkey = $lang['langkey'];
            $isokey = $lang['isokey'];
            $flagkey = $lang['flagkey'];
            $statuskey = $lang['statuskey'];

            if ($this->get('lang')) {
                $this->lang = $this->get('lang');
            }

            if (in_array($this->lang(), $isokey)) {
                foreach ($isokey as $key => $value) {
                    if ($statuskey[$key] == 1) {
                        $this->language[$value] = [
                            'title' => $langtitle[$key],
                            'flag' =>  $flagkey[$key],
                            'iso' =>  $isokey[$key],
                            'active' => false
                       ];
                    }

                    if ($this->lang() == $value) {
                        $this->language[$value]['active'] = true;
                        $this->langBreadcrumb = $this->language[$value]['title'];
                    }
                }
            }
        }
    }

    public function existsLang()
    {
        $this->lang = 'pt_BR';

        if ($this->get('lang')) {
            $this->lang = $this->get('lang');
        }
    }

    public function pathlink($folder, $module, $operation = 'manage', $id = null)
    {
        $folder = str_replace('-', '/', $folder.'/'.$module);

        $path = config('app.PATH_SYSTEM').$folder.'&operation='.$operation;

        if ($operation == 'update' || $operation == 'view') {
            return $path.'&id='.$id;
        }

        return $path;
    }

    public function pathlang($lang = null, $path = null, $operator = '&')
    {
        $pathfull = null;

        if (count($this->language) >= 2) {
            if (!$path) {
                $pathfull = config('app.BASE_URL').$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
            }
            else {
                $pathfull = $path;
            }

            if (!$lang) {
                $lang = $this->lang();
            }

            if (!$path) {
                $langcheck = explode('lang=', $_SERVER['REQUEST_URI']);
                $base = explode('base=', $_SERVER['REQUEST_URI']);

                if (count($base) == 1) {
                    $operator = '?';
                }

                if (count($langcheck) > 1) {
                    $pathfull = str_replace(array($operator.'lang='.$this->get('lang')),array($operator.'lang='.$lang), $pathfull);
                }
                else {
                    $pathfull = $pathfull.$operator.'lang='.$lang;
                }
            }
            else {
                $langcheck = explode($operator.'lang=', $pathfull);

                if (count($langcheck) > 1) {
                    $pathfull = str_replace(array($operator.'lang='.$this->get('lang')),array($operator.'lang='.$lang), $pathfull);
                }
                else {
                    $pathfull = $pathfull.$operator.'lang='.$lang;
                }
            }
        }
        else {
            $pathfull = $path;
        }

        return $pathfull;
    }

    public function pathPreservLink($path = null, $vars = [], $not = [])
    {
        $pathActive = config('app.BASE_URL').$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];

        $varsPathActive = explode('&', $pathActive);

        $varsSend = null;

        if (is_array($vars)) {
            foreach ($vars as $arrayVars) {
                foreach ($arrayVars as $key => $value) {
                    $varsSend .= '&'.$key.'='.$value;
                }
            }
        }

        $pathSend = $this->pathlang(null, $path.$varsSend);

        $varsPathSend = explode('&', $pathSend);

        $pathNew = $varsPathActive[0].'&'.$varsPathSend[1];

        unset($varsPathActive[0], $varsPathActive[1]);
        unset($varsPathSend[0], $varsPathSend[1]);

        $varsSaveActive = null;

        foreach ($varsPathActive as $value) {
            $vars = explode('=', $value);

            if (!array_key_exists($vars[0], $not)) {
                $varsSaveActive[$vars[0]] = $vars[1];
            }
        }

        foreach ($varsPathSend as $value) {
            $vars = explode('=', $value);

            $varsSaveSend[$vars[0]] = $vars[1];

            if (is_array($varsSaveActive)) {
                $varsSaveActive[$vars[0]] = $vars[1];
            }
            else {
                $varsSaveActive[$vars[0]] = $vars[1];
            }

            if ($vars[1] == 'none-select') {
                unset($varsSaveActive[$vars[0]]);
            }
        }

        foreach ($varsSaveActive as $key => $value) {
            $pathNew .= '&'.$key.'='.$value;
        }

        return $pathNew;
    }

    public function post($key, $type = 'string')
    {
        $post = isset($_POST[$key]) ? $$key = $_POST[$key] : $$key = null;

        if ($post == null || $post == '') {
            return null;
        }
        else {
            return $this->processData($post, $type);
        }
    }

    public function get($key, $type = 'injection')
    {
        $get = isset($_GET[$key]) ? $$key = $_GET[$key] : $$key = null;

        if ($get == null) {
            return null;
        }
        else {
            return $this->processData($get, $type);
        }
    }

    public function getJavaScript()
    {
        if ($this->get('base') && $this->get('operation')) {
            if (file_exists(config('app.ROOT_CMS').'/'.$this->get('base').'/js.php')) {
                include(config('app.ROOT_CMS').'/'.$this->get('base').'/js.php');
            }
        }
    }

    public function processData($data, $type = 'string')
    {
        switch($type)
        {
            case 'injection': return trim(addslashes($data)); break;
            case 'string': return trim(addslashes(strip_tags($this->rteSafeString($data)))); break;
            case 'text': return htmlentities($this->rteSafe($data), ENT_QUOTES); break;
            case 'no-tags': return trim(addslashes(strip_tags($data))); break;
            case 'date': return trim($this->processDate($data, 'mysql')); break;
            case 'date-month': return trim($this->processDate($data, 'mysql-month')); break;
            case 'array': return implode('-', addslashes(str_replace('"', '\'\'', $data))); break;
            case 'array_explode': return str_replace('"', '\'\'', $data); break;
            case 'array_explode_all':
                $_return = null;

                foreach ($this->processData($data, 'array_explode') as $key => $value) {
                    if (!empty($value)) {
                        $_return[] = str_replace('/', '/', htmlentities($this->processData($value, 'text'), ENT_QUOTES));
                    }
                    else {
                        $_return[] = '';
                    }
                }

                return $_return;
            break;

            case 'array_explode_shift':
                $_return = null;

                array_shift($data);

                foreach ($this->processData($data, 'array_explode') as $key => $value) {
                    if (!empty($value)) {
                        $_return[] = str_replace('/', '/', htmlentities($this->processData($value, 'text'), ENT_QUOTES));
                    }
                    else {
                        $_return[] = '';
                    }
                }

                return $_return;
            break;
            case 'json': return json_encode($this->processData($data, 'array_explode_all')); break;
            case 'json_shift': return json_encode($this->processData($data, 'array_explode_shift')); break;
            case 'serializestring': return htmlentities(str_replace('"', "'", $data), ENT_QUOTES); break;
            case 'serialize':
                $_return = null;

                array_shift($data);

                foreach ($this->processData($data, 'array_explode') as $key => $value) {
                    if (!empty($value)) {
                        $_return[] = $value;
                    }
                    else {
                        $_return[] = '';
                    }
                }

                if ($_return) {
                    return serialize($_return);
                }
                else {
                    return null;
                }
            break;
            case 'serialize_full':
                $_return = null;

                foreach ($this->processData($data, 'array_explode') as $key => $value) {
                    if (!empty($value)) {
                        $_return[] = $value;
                    }
                    else {
                        $_return[] = '';
                    }
                }

                if ($_return) {
                    return serialize($_return);
                }
                else {
                    return null;
                }
            break;
            case 'serialize_tag':
                $dataReturn = null;

                foreach ($this->processData($data, 'array_explode') as $key => $value) {
                    if (!empty($value)) {
                        $dataReturn[] = array('title' => $value, 'value' => $this->processString($value, 'slug'));
                    }
                }

                if ($dataReturn) {
                    return serialize($dataReturn);
                }
                else {
                    return null;
                }
            break;
            case 'int': return intval($data); break;
            case 'float': return floatval($data); break;
            case 'boolean': if ($data == 1 || $data == 'on') return 1; else return 2; break;
            case 'amount': return number_format(str_replace(',', '.', str_replace('.', '', $data)), 2, '.', ''); break;
            case 'amount_15-8': return number_format($data, 8, '.', ''); break;
            case 'cpf': if ($this->validaCPF($data)) { return $data; } break;
            case 'email': return strtolower($data); break;
            case 'phone': return str_replace('_', '', $data); break;
            case 'code': return base64_encode(htmlentities($data, ENT_QUOTES)); break;
            case 'slug': return $this->generateSlug($data); break;
            case 'cammel-case': return mb_convert_case(stripcslashes($data), MB_CASE_TITLE, "UTF-8"); break;
            case 'str_pad10': return str_pad($data, 10, '0', STR_PAD_LEFT); break;
            case 'base64': return base64_encode($data); break;
        }
    }

    public function getBoolean($data)
    {
        if ($data == 1 || $data == 'on') return 1; else return 2;
    }

    public function rteSafe($strText)
    {
        $tmpString = $strText;

        $tmpString = str_replace("\'", "'", $tmpString);
        $tmpString = str_replace("'", "\'", $tmpString);
        $tmpString = str_replace("–", "-", $tmpString);
        $tmpString = str_replace('<h1>&nbsp;</h1>', '', $tmpString);
        $tmpString = str_replace('<h2>&nbsp;</h2>', '', $tmpString);
        $tmpString = str_replace('<p>&nbsp;</p>', '', $tmpString);

        return $tmpString;
    }

    public function rteSafeString($strText)
    {
        $tmpString = $strText;

        $tmpString = str_replace("\'", "'", $tmpString);
        $tmpString = str_replace('"', "''", $tmpString);
        $tmpString = str_replace("'", "\'", $tmpString);
        $tmpString = str_replace("–", "-", $tmpString);

        return $tmpString;
    }

    public function processString($string, $type = 'string', $characters = 'all', $tags = FALSE, $encode = 'UTF-8')
    {
        if ($string) {
            $string = htmlspecialchars_decode($this->utfCharacters($string));

            switch($type)
            {
                case 'string':
                    if ($characters == 'all') {
                        return stripcslashes($string);
                    }
                    else {
                        if ($tags == FALSE) {
                            $string = strip_tags($string);
                        }

                        if (mb_strlen($string) > $characters) {
                            $string = mb_substr($string, 0, $characters - 3, $encode).'...';
                        }
                        else {
                            $string = mb_substr($string, 0, $characters, $encode);
                        }

                        return stripcslashes($string);
                    }
                break;
                case 'text':  return html_entity_decode($string, ENT_QUOTES); break;
                case 'amount': if ($string && $string != '0.00') { return number_format(stripcslashes($string), 2, ',', '.'); } break;
                case 'amountPoint': return number_format(stripcslashes($string), 2, '.', '.'); break;
                case 'amountTag': if($string) { return 'R$'.$this->processString($string, 'amount'); } break;
                case 'amount_15-8': if($string) { return number_format($string, 8, '.', ''); } break;
                case 'hour2digits': return substr($string, 0, 5); break;
                case 'notags': return strip_tags(html_entity_decode($string, ENT_QUOTES)); break;
                case 'json': return json_decode($string); break;
                case 'array': return explode('-', stripcslashes($string)); break;
                case 'int':
                    if ($string) {
                        return intval($string);
                    }
                break;
                case 'slug': return $this->generateSlug($string);
                case 'unserializestring':  return html_entity_decode($string, ENT_QUOTES); break;
                case 'email': return strtolower($string); break;
                case 'pontoparavirgula':
                    if ($data != '' && $data && $data != 0) {
                        return trim(str_replace('.', ',', $data) . $sufix);
                    }
                break;
                case 'str_pad10': return str_pad($string, 10, '0', STR_PAD_LEFT);
                case 'str_pad5': return str_pad($string, 5, '0', STR_PAD_LEFT);
                case 'str_pad7': return str_pad($string, 7, '0', STR_PAD_LEFT); break;
                case 'callto': return '+55'.preg_replace("/[^0-9]/", "", $string);
                case 'cammel-case': return mb_convert_case(stripcslashes($string), MB_CASE_TITLE, "UTF-8"); break;
                case 'cep-slug': return str_replace('-', '', $string); break;
                case 'first-name':
                    $explode = explode(' ', $string);

                    return $this->processString($explode[0]);
                break;
                case 'code': return html_entity_decode(base64_decode($string), ENT_QUOTES); break;

            }
        }
    }

    public function generateSlug($string, $separador = '-')
    {
        $string = trim($string);

        $string = str_replace(['á', 'ã', 'à', 'ä', 'â', 'ª', 'Á', 'À', 'Â', 'Ã', 'Ä'], ['a', 'a', 'a', 'a', 'a', 'a', 'A', 'A', 'A', 'A', 'A'], $string);
        $string = str_replace(['é', 'è', 'ë', 'ê', 'É', 'È', 'Ê', 'Ë'], ['e', 'e', 'e', 'e', 'E', 'E', 'E', 'E'], $string );
        $string = str_replace(['í', 'ì', 'ï', 'î', 'Í', 'Ì', 'Ï', 'Î'], ['i', 'i', 'i', 'i', 'I', 'I', 'I', 'I'], $string);
        $string = str_replace(['ó', 'õ', 'ò', 'ö', 'ô', 'Ó', 'Ò', 'Õ', 'Ö', 'Ô'], ['o', 'õ', 'o', 'o', 'o', 'O', 'O', 'O', 'O', 'O'], $string);
        $string = str_replace(['ú', 'ù', 'ü', 'û', 'Ú', 'Ù', 'Û', 'Ü'], ['u', 'u', 'u', 'u', 'U', 'U', 'U', 'U'], $string);
        $string = str_replace(['ñ', 'Ñ', 'ç', 'Ç'], ['n', 'N', 'c', 'C'], $string);
        $string = str_replace(["\\", "¨", "º", "~", "#", "@", "|", "!", "\"", "·", "$", "%", "&", "/", "(", ")", "?", "'", "¡", "¿", "[", "^", "`", "]", "+", "}", "{", "¨", "´", ">", "<", ";", ",", ":", "."], '-', $string);
        $string = str_replace("_", "-", $string);
        $string = str_replace(" ", "-", $string);

        $slug = iconv('UTF-8', 'ASCII//TRANSLIT', $string);
        $slug = preg_replace("/[^a-zA-Z0-9\/_|+ -]/", '', $slug);
        $slug = strtolower(trim($slug, $separador));
        $slug = preg_replace("/[\/_|+ -]+/", $separador, $slug);

        return $slug;
    }

    public function generateSlugOnlyChars($string, $separador = '-')
    {
        $string = trim($string);

        $string = str_replace(['á', 'ã', 'à', 'ä', 'â', 'ª', 'Á', 'À', 'Â', 'Ã', 'Ä'], ['a', 'a', 'a', 'a', 'a', 'a', 'A', 'A', 'A', 'A', 'A'], $string);
        $string = str_replace(['é', 'è', 'ë', 'ê', 'É', 'È', 'Ê', 'Ë'], ['e', 'e', 'e', 'e', 'E', 'E', 'E', 'E'], $string );
        $string = str_replace(['í', 'ì', 'ï', 'î', 'Í', 'Ì', 'Ï', 'Î'], ['i', 'i', 'i', 'i', 'I', 'I', 'I', 'I'], $string);
        $string = str_replace(['ó', 'õ', 'ò', 'ö', 'ô', 'Ó', 'Ò', 'Õ', 'Ö', 'Ô'], ['o', 'õ', 'o', 'o', 'o', 'O', 'O', 'O', 'O', 'O'], $string);
        $string = str_replace(['ú', 'ù', 'ü', 'û', 'Ú', 'Ù', 'Û', 'Ü'], ['u', 'u', 'u', 'u', 'U', 'U', 'U', 'U'], $string);
        $string = str_replace(['ñ', 'Ñ', 'ç', 'Ç'], ['n', 'N', 'c', 'C'], $string);
        $string = str_replace("_", "-", $string);
        $string = str_replace(" ", "-", $string);

        $slug = iconv('UTF-8', 'ASCII//TRANSLIT', $string);
        $slug = mb_strtolower(trim($slug, $separador));

        return $slug;
    }

    public function processDate($date, $type)
    {
        if ($date && $date != '0000-00-00' && $date != '00-00-0000' && $date != '0000-00-00 00:00:00' && $date != '00-00-0000 00:00:00') {
            switch($type)
            {
                case 'mysql':
                    $year = mb_substr($date, 6, 4);
                    $month = mb_substr($date, 3, 2);
                    $day = mb_substr($date, 0, 2);

                    if (is_numeric($day) && is_numeric($month) && is_numeric($year) && checkdate($month, $day, $year)) {
                        return mb_substr($date, 6, 4).'-'.mb_substr($date, 3, 2).'-'.mb_substr($date, 0, 2);
                    }
                    else {
                        return null;
                    }
                break;
                case 'mysql-treataccess':
                    $year = $this->processDate($date, 'year-treataccess');
                    $month = $this->processDate($date, 'month-treataccess');
                    $day = mb_substr($date, 0, 2);

                    if (checkdate($month, $day, $year)) {
                        return $year.'-'.$month.'-'.$day;
                    }
                    else {
                        return null;
                    }
                break;
                case 'year-treataccess':
                    $year = mb_substr($date, 7, 3);

                    if ($year > 1 && $year < 18) {
                        $year = 20 . $year;
                    }
                    if ($year > 40) {
                        $year = 19 . $year;
                    }

                    return intval($year);
                break;
                case 'month-treataccess':
                    $month = mb_substr($date, 3, 3);

                    switch($month)
                    {
                        case 'jan': return '01'; break;
                        case 'fev': return '02'; break;
                        case 'mar': return '03'; break;
                        case 'abr': return '04'; break;
                        case 'mai': return '05'; break;
                        case 'jun': return '06'; break;
                        case 'jul': return '07'; break;
                        case 'ago': return '08'; break;
                        case 'set': return '09'; break;
                        case 'out': return '10'; break;
                        case 'nov': return '11'; break;
                        case 'dez': return '12'; break;
                    }
                break;

                case 'mysql-month':
                    $year = mb_substr($date, 3, 4);
                    $month = mb_substr($date, 0, 2);

                    return $year.'-'.$month;

                break;
                case 'day': return mb_substr($date, 8, 2); break;
                case 'month': return mb_substr($date, 5,2); break;
                case 'year': return mb_substr($date, 0, 4); break;
                case 'month-year': return mb_substr($date, 5,2).'/'.mb_substr($date, 0, 4); break;
                case 'hour': return mb_substr($date, 11, 2); break;
                case 'minutes': return mb_substr($date, 14, 2); break;
                case 'seconds': return mb_substr($date, 17, 2); break;
                case 'brazil': return $this->processDate($date,'day').'/'.$this->processDate($date, 'month').'/'.$this->processDate($date,'year'); break;
                case 'timestamp_brazil': return $this->processDate($date,'day').'/'.$this->processDate($date, 'month').'/'.$this->processDate($date,'year').' '.mb_substr($date,11,8); break;
                case 'timestamp_legal': return $this->processDate($date,'day').'/'.$this->processDate($date, 'month').'/'.$this->processDate($date,'year').' '.$this->processDate($date, 'hour_abbr'); break;
                case 'hour_abbr':
                    $hour = mb_substr($date,11,2).'h'.mb_substr($date,14,2);

                    if ($hour == 'h') {
                        $hour = mb_substr($date,0,2).'h'.mb_substr($date,3,2);
                    }

                    return $hour;
                break;
                case 'month_name':
                    switch($date)
                    {
                        case '01': return 'janeiro'; break;
                        case '02': return 'fevereiro'; break;
                        case '03': return 'março'; break;
                        case '04': return 'abril'; break;
                        case '05': return 'maio'; break;
                        case '06': return 'junho'; break;
                        case '07': return 'julho'; break;
                        case '08': return 'agosto'; break;
                        case '09': return 'setembro'; break;
                        case '10': return 'outubro'; break;
                        case '11': return 'novembro'; break;
                        case '12': return 'dezembro'; break;
                    }
                break;
                case 'weekday':
                    $weekday = date('w', mktime(0, 0, 0, $this->processDate($date,'month'), $this->processDate($date,'day'), $this->processDate($date,'year')));
                    switch($weekday)
                    {
                        case '0': return 'Domingo'; break;
                        case '1': return 'Segunda-Feira'; break;
                        case '2': return 'Terça-Feira'; break;
                        case '3': return 'Quarta-Feira'; break;
                        case '4': return 'Quinta-Feira'; break;
                        case '5': return 'Sexta-Feira'; break;
                        case '6': return 'Sábado'; break;
                    }
                break;
                case 'extensive': return $this->processDate($date,'day').' de '.$this->processDate($this->processDate($date,'month'),'month_name').' de '.$this->processDate($date,'year'); break;
                case 'extensive_hour': return $this->processDate($date,'extensive'). ' às '.$this->processDate($date,'hour_abbr'); break;
                case 'extensive_weekday': return $this->processDate($date,'weekday').', '.$this->processDate($date,'extensive_hour'); break;
                case 'age':
                    $age = floor((time() - strtotime($date)) / (60 * 60 * 24 * 365));

                    return intval($age) . ' anos';
                break;
            }
        }
    }

    public function getFeedback($key, $status)
    {
        if ($this->privilege['god'] == 1) {
            $user = parent::dbFetch("SELECT `id_administrator`, `params_administrator` FROM `mod_administrator` WHERE `id_administrator` = '".ADMINISTRATOR."'");

            $userParams = null;

            if ($user[1]) {
                $params = unserialize($user[1]);

                $keyActiveModule = $this->key;

                if ($params) {
                    foreach ($params as $keyParams => $value) {
                        if ($params['module'] === $keyActiveModule) {
                            if (is_array($params['id'])) {
                                $userParams = "AND `user_".$keyActiveModule."` = '".$user[0]."'";
                            }
                            else {
                                $userParams .= "AND `".$params['conn']."_".$keyActiveModule."` = '".$params['id']."'";
                            }
                        }
                    }
                }
            }

            $table = $this->modulesSystem[$key]['table'];
            $sufix = $this->modulesSystem[$key]['sufix'];

            switch($status)
            {
                case 'total': return $this->dbNumRows("SELECT `id_".$sufix."` FROM `".$table."` WHERE `status_".$sufix."` <> 'deleted'".$userParams) ?: 0; break;
                case 'active': return $this->dbNumRows("SELECT `id_".$sufix."` FROM `".$table."` WHERE `status_".$sufix."` = 'active'".$userParams) ?: 0; break;
                case 'disabled': return $this->dbNumRows("SELECT `id_".$sufix."` FROM `".$table."` WHERE `status_".$sufix."` = 'disabled'".$userParams) ?: 0; break;
                case 'pendent': return $this->dbNumRows("SELECT `id_".$sufix."` FROM `".$table."` WHERE `status_".$sufix."` = 'pendent'".$userParams) ?: 0; break;
                case 'trash': return $this->dbNumRows("SELECT `id_".$sufix."` FROM `".$table."` WHERE `status_".$sufix."` = 'trash'".$userParams) ?: 0; break;
            }
        }
    }
    public function sendEmailNew($body, $to = null, $manipuleTitle = null, $base = 'configFormDefault')
    {
        $baseInfo = $this->getBaseData($base);

        $message = '<h3>'.$baseInfo['header'].'</h3><hr>'.$body;

        $smtp = $this->getBaseData('pagesmtp');
        $assets = $this->getBaseData('pageAssets');

        try {
            $mail = new \PHPMailer\PHPMailer\PHPMailer(true);
            $mail->isSMTP();
            $mail->IsHTML(true);
            $mail->Host = $smtp['host'];
            $mail->Port = $smtp['port'];
            $mail->SMTPSecure = $smtp['secure'];
            $mail->SMTPAuth = true;
            $mail->SMTPDebug = 2;
            $mail->Username = $smtp['user'];
            $mail->Password = $this->processString($smtp['password'], 'text');

            $mail->setFrom($smtp['user'], utf8_decode($baseInfo['nameFrom']));

            if (!$to) {
                $mail->addAddress($baseInfo['emailTo'], utf8_decode($baseInfo['nameTo']));

                if ($baseInfo['nameCC'] && $baseInfo['emailCC']) {
                    $name = unserialize($baseInfo['nameCC']);
                    $email = unserialize($baseInfo['emailCC']);

                    for ($i = 0; $i < count($name); $i++) {
                        $mail->addCC($email[$i], utf8_decode($this->processString($name[$i])));
                    }
                }
            }
            else {
                $mail->addAddress($to[0], utf8_decode($to[1]));
            }

            $subject = utf8_decode($baseInfo['header'].' '.$manipuleTitle);
            $mail->Subject = $subject;
            $file = ROOT_SITE.'/app/template/email-template.html';
            $template = fread(fopen($file, 'r'), filesize($file));

            $data[] = ['content_subject', $subject];
            $data[] = ['content_body', utf8_decode($message)];
            $data[] = ['path_root', PATH_SITE];
            $data[] = ['path_header', config('app.PATH_CMS').'/public/img/email-header.jpg'];
            $data[] = ['path_footer', config('app.PATH_CMS').'/public/img/email-footer.jpg'];

            foreach ($data as $key => $value) {
                $template = str_replace('%%'.$value[0].'%%', $value[1], $template);
            }

            $mail->Body = stripslashes($template);

            $mail->send();
        } catch (\PHPMailer\PHPMailer\Exception $e) {
            echo 'Message could not be sent. Mailer Error: ', $mail->ErrorInfo;
            exit;
        }
    }

    public function getImageDefault($file, $folder = 'system')
    {
        if (file_exists(config('app.ROOT_UPLOAD').'/'.$folder.'/'.$file)) {
            return '<a class="blue" href="'.config('app.PATH_UPLOAD').'/'.$folder.'/'.$file.'" data-rel="colorbox"><img src="'.config('app.PATH_UPLOAD').'/'.$folder.'/'.$file.'" '.$html.' alt="" title="Visualizar" class="img-fluid" /></a>';
        }
    }

    public function timeDiff($date, $prefix, $action = array('foi publicado', 'será publicado'))
    {
        $periodArray = ['segundo', 'minuto', 'hora', 'dia', 'semana', 'mês', 'ano', 'década'];
        $durationArray = ['60', '60', '24', '7', '4.35', '12', '10'];

        $unixNow = time();
        $unixSelect = strtotime($date);

        if ($unixNow > $unixSelect) {
            $prefix = $prefix.$action[0].' há ';
            $diffTime = $unixNow - $unixSelect;
            $sufix = " atrás.";
        }
        else {
            $prefix = $prefix.$action[1].' em ';
            $diffTime = $unixSelect - $unixNow;
            $sufix = ".";
        }

        for ($j = 0; $diffTime >= $durationArray[$j] && $j < count($durationArray)-1; $j++) {
            $diffTime /= $durationArray[$j];
        }

        $diffTime = round($diffTime);

        if ($diffTime != 1) {
            if ($periodArray[$j] === 'mês') {
                $periodArray[$j] = 'meses';
            }
            else {
                $periodArray[$j] .= "s";
            }
        }

        return "{$prefix} $diffTime $periodArray[$j]{$sufix}";
    }

    public function allMultiplesUniqueId($key, $select, $unique = null)
    {
        $dataMultiple = null;

        if ($unique) {
            $unique = " AND `administrator_".$key."` = '".$unique."'";
        }

        $queryMultiple = $this->dbQuery("SELECT `".$select."_".$key."` FROM `mod_".$key."` WHERE `status_".$key."` = 'active'".$unique);

        while ($resultMultiple = $queryMultiple->fetch_array()) {
            if ($resultMultiple[0] != '') {
                $dataMultiple[] = json_decode($resultMultiple[0]);
            }
        }

        $dataSelect = [];

        if ($dataMultiple) {
            foreach ($dataMultiple as $keyNivel1 => $valueNivel1) {
                foreach ($valueNivel1 as $keyNivel2 => $valueNivel2) {
                    $dataSelect[] = intval($valueNivel2);
                }
            }
        }

        $unique = array_unique($dataSelect);

        return $unique;
    }

    public function setVideoTemplate($url)
    {
        if (strpos($url, 'youtube.com')) {
            $urlParse = parse_url($url);

            if (array_key_exists('query', $urlParse)) {
                $vid = parse_str($urlParse['query'], $output);

                $id_video = $output['v'];

                $data['type'] = 'youtube';
                $data['code'] = $id_video;

                return json_encode($data);
            }
        }
        else if(strpos($url, 'youtu.be')) {
            $urlParse = parse_url($url);

            if (array_key_exists('path', $urlParse)) {
                $data['type'] = 'youtube';
                $data['code'] = str_replace('/', '', $urlParse['path']);

                return json_encode($data);
            }
        }
        else if (strpos($url, 'vimeo.com')) {
            $id_video = explode('vimeo.com/', $url);
            $id_video = $id_video[1];

            $data['type'] = 'vimeo';
            $data['code'] = $id_video;

            return json_encode($data);
        }
        else {
            return null;
        }
    }

    public function inputSelectSerializeData($data, $selected = null)
    {
        $dataReturn = null;

        if ($data) {
            foreach ($data as $key => $value) {
                if ($value['value'] == $selected) {
                    $selectedHtml = ' selected';
                }
                else {
                    $selectedHtml = null;
                }

                $dataReturn .= '<option value="'.$value['value'].'"'.$selectedHtml.'>'.$this->processString($value['title']).'</option>';
            }
        }
        else {
            $dataReturn .= '<option value="">Nenhum resultado encontrado</option>';
        }

        return $dataReturn;
    }

    public function imgSerialize($file, $path, $delete, $folder = 'configuration')
    {
        $dataReturn = null;

        if (is_array($file)) {
            $vars = explode('.'.$file['extension'], $file['name']);

            $hashImage = $vars[0];
            $extensionImageReal = $file['extension'];

            if ($this->modules->activeWebp) {
                $extensionWebp = 'webp';

                $extensionExecute = $extensionWebp;
            }
            else {
                $extensionExecute = $extensionImageReal;
            }

            $file = $hashImage.'.'.$extensionExecute;

            if (!file_exists(config('app.ROOT_UPLOAD').'/'.$folder.'/images/default/'.$file)) {
                $file = $hashImage.'.'.$extensionImageReal;
            }

            if ($file) {
                if (file_exists(config('app.ROOT_UPLOAD').'/'.$folder.'/images/default/'.$file)) {
                    $dataReturn = '<a href="'.config('app.PATH_UPLOAD').'/'.$folder.'/images'.'/default'.'/'.$file.'" data-toggle="lightbox"><img src="'.config('app.PATH_UPLOAD').'/'.$folder.'/images'.'/default'.'/'.$file.'" class="img-fluid" alt="" title="Visualizar" /></a>';
                }
            }

            $dataReturn .=
                '<div style="margin-top: 10px;">
                    <a href="'.$path.'&deleteImagemBaseData='.$delete[0].'-'.$delete[1].'" title="Excluir imagem"><i class="fa fa-trash mr-1"></i> Excluir imagem</a>
                </div>';
        }

        return $dataReturn;
    }

    public function pdfSerialize($file, $path, $delete, $folder = 'system')
    {
        $dataReturn = null;

        if (is_array($file)) {
            $vars = explode('.'.$file['extension'], $file['name']);

            $hashImage = $vars[0];
            $extensionImageReal = $file['extension'];
        }

        $file['root'] = config('app.ROOT_UPLOAD').'/'.$folder.'/files/'.$file['name'];

        if (file_exists($file['root'])) {
            $dataReturn = '<a class="blue" href="'.config('app.PATH_API').'/getDownload.php?parameter='.base64_encode(json_encode($file)).'" target="_blank"><i class="fa fa-file-pdf-o bigger-230"></i></a>';
        }

        $dataReturn .=
            '<div style="margin-top: 10px;">
                <a class="blue" href="'.$path.'&deleteImagemBaseData='.$delete[0].'-'.$delete[1].'" title="Excluir pdf">
                    <i class="fa fa-trash bigger-130"></i> Excluir pdf
                </a>
            </div>';

        return $dataReturn;
    }

    public function jsonSave($path, $data)
    {
        $file = fopen($path, 'w+');

        fwrite($file, json_encode($data));
        fclose($file);
    }

    public function generateExcel($data, $table)
    {
        $fileDownload = 'backup-'.$this->generateSlug($table).'-'.date('Y-m-d').'.xls';

        define('EOL',(PHP_SAPI == 'cli') ? PHP_EOL : '<br />');

        require_once config('app.ROOT_CMS').'/app/dump/PHPExcel.php';

        $objPHPExcel = new PHPExcel();

        $objPHPExcel->getProperties()->setCreator(config('app.LABEL_SYSTEM_NAME'))
            ->setTitle("Backup - Tabela ".$table)
            ->setDescription("Este documento foi gerado automaticamente.");

        $char = 65;

        $totalItens = count($data);

        for ($i = 0; $i < $totalItens; $i++) {
            if ($i == 0) {
                foreach ($data[$i] as $key => $value) {
                    $objPHPExcel->setActiveSheetIndex(0)->setCellValue(chr($char).'1', $value['label']);

                    $char++;
                }
            }
        }

        $char = 65;
        $cel = 2;

        for ($i = 0; $i < $totalItens; $i++) {
            foreach ($data[$i] as $key => $value) {
                $objPHPExcel->setActiveSheetIndex(0)->setCellValue(chr($char).$cel, $value['value']);

                $char++;
            }

            $char = 65;
            $cel++;
        }

        $objPHPExcel->getActiveSheet()->setTitle("Backup - Tabela ".$table);

        $callStartTime = microtime(true);
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        $objWriter->save(str_replace('.php', '.xlsx', config('app.ROOT_CMS').'/app/dump/excel/'.$fileDownload));
        $callEndTime = microtime(true);
        $callTime = $callEndTime - $callStartTime;

        $file = config('app.PATH_CMS').'/app/dump/excel/'.$fileDownload;
        echo '<div class="alert alert-success">
        <button type="button" class="close" data-dismiss="alert"><i class="icon-remove"></i></button>
        <strong><i class="icon-ok-sign"></i> Backup em formato excel realizado com sucesso!</strong>
        </div>';

        echo '<button class="btn btn-primary" data-link="'.$file.'" title="Download do arquivo Excel">
        <i class="fa fa-download align-bottom bigger-125"></i> Download do arquivo Excel
        </button>
        <div class="hr hr-dotted"></div>
        ';
    }

    function arrayMergeCategorys($arrayNew, $result = null, $deleteFirst = true)
    {
        if (is_null($result)) {
            $result = [];
        }
        else {
            $result = json_decode($result, true);
        }

        foreach ($arrayNew as $i => $data) {
            if ($deleteFirst) {
                array_shift($data);
            }

            foreach ($data as $id => $value) {
                $result[$id][$i] = $value;
            }
        }

        return $result;
    }

    public function ageLabel($dateInit, $dateEnd)
    {
        if ($dateInit == 0 && $dateEnd == 0) {
            return 'Livre';
        }
        else if ($dateInit == 0 && $dateEnd != 0) {
            return 'até '.$dateEnd . ' anos';
        }
        else if ($dateInit != 0 && $dateEnd != 0) {
            return $dateInit . ' a ' . $dateEnd . ' anos';
        }
        else if ($dateInit != 0 && $dateEnd == 0) {
            return $dateInit . ' anos acima';
        }
    }

    public function checkCityAccess($cityString, $stateString)
    {
        $cityString = explode(' (', $cityString);
        $cityString = $cityString[0];

        $result = $this->dbFetch("SELECT `id_ibge-city` as city, `state_ibge-city` as state FROM `sis_ibge-city`
                                  INNER JOIN `sis_ibge-state` ON (`id_ibge-state` = `state_ibge-city`)
                                  WHERE `name_ibge-city` LIKE '%".$cityString."' AND (`name_ibge-state` LIKE '%".$stateString."%' OR `iso_ibge-state` LIKE '%".$stateString."%')");

        $city = $result['city'];
        $state = $result['state'];

        return [$city, $state];
    }

    public function validaCPF($cpf = false)
    {
        if (!$cpf) {
            return false;
        }

        $cpf = preg_replace( '/[^0-9]/is', '', $cpf );

        if (strlen($cpf) != 11) {
            return false;
        }

        $digitos = substr($cpf, 0, 9);

        $novo_cpf = $this->calc_digitos_posicoes($digitos);

        $novo_cpf = $this->calc_digitos_posicoes($novo_cpf, 11);

        if ($novo_cpf === $cpf) {
            return true;
        }
        else {
            return false;
        }
    }

    public function calc_digitos_posicoes($digitos, $posicoes = 10, $soma_digitos = 0)
    {
        for ($i = 0; $i < strlen($digitos); $i++) {
            $soma_digitos = $soma_digitos + ($digitos[$i] * $posicoes);
            $posicoes--;
        }

        $soma_digitos = $soma_digitos % 11;

        if ($soma_digitos < 2) {
            $soma_digitos = 0;
        }
        else {
            $soma_digitos = 11 - $soma_digitos;
        }

        $cpf = $digitos . $soma_digitos;

        return $cpf;
    }

    public function getRepository($selectedData = 1, $file = null, $output = 'array', $order = true)
    {
        $dataReturn = null;

        $filePath = ROOT_SITE.'/app/repository/'.$file.'.json';

        if (file_exists($filePath)) {
            $repository = file_get_contents(ROOT_SITE.'/app/repository/'.$file.'.json');

            $repository = json_decode($repository, true);
        }
        else {
            $dirProviders = ROOT_SITE.'/providers';

            if (is_dir($dirProviders)) {
                $iterator = new DirectoryIterator($dirProviders);

                while ($iterator->valid()) {
                    $entry = $iterator->getFilename();

                    $path = $dirProviders.'/'.$entry;

                    $iterator->next();

                    if (is_dir($path)) {
                        $repositoryDir = $path.'/repository';

                        if (is_dir($repositoryDir)) {
                            if (file_exists($repositoryDir.'/'.$file.'.json')) {
                                $repository = file_get_contents($repositoryDir.'/'.$file.'.json');

                                $repository = json_decode($repository, true);
                            }
                        }
                    }
                 }
            }
        }

        if ($repository) {
            if ($order) {
                asort($repository);
            }

            foreach ($repository as $key => $value) {
                $selected = false;

                if ($key == $selectedData) {
                    $selected = true;

                    if ($output == 'view') {
                        return $this->processString($value);
                    }
                }

                $dataReturn[] = [
                    'title' => $this->processString($value),
                    'value' => intval($key),
                    'selected' => $selected
                ];
            }

            if ($output != 'view') {
                return $dataReturn;
            }
        }
    }

    public function getExtras($data, $type, $sufix = null)
    {
        switch ($type)
        {
            case 'pontoparavirgula':
                if ($data != '' && $data && $data != 0) {
                    return trim(str_replace('.', ',', $data) . $sufix);
                }
            break;

            case 'genre-icon':
                if ($data == 1) {
                    return '<i class="fa fa-male" title="Masculino"></i>';
                }
                else if ($data == 2) {
                    return '<i class="fa fa-female" title="Feminino"></i>';
                }
            break;
        }
    }

    public function getAge($date)
    {
        $data = $this->processDate($date, 'brazil');

        list($dia, $mes, $ano) = explode('/', $data);

        $hoje = mktime(0, 0, 0, date('m'), date('d'), date('Y'));
        $nascimento = mktime( 0, 0, 0, $mes, $dia, $ano);

        $idade = floor((((($hoje - $nascimento) / 60) / 60) / 24) / 365.25);

        if ($idade == 1) {
            return '('.$idade . ' ano)';
        }
        else {
            return '('.$idade . ' anos)';
        }
    }

    public function utfCharacters($data)
    {
        $charUtf8 = ["u00e1", "u00e0", "u00e2", "u00e3", "u00e4", "u00c1", "u00c0", "u00c2", "u00c3", "u00c4", "u00e9", "u00e8", "u00ea", "u00ea", "u00c9", "u00c8", "u00ca", "u00cb", "u00ed", "u00ec", "u00ee", "u00ef", "u00cd", "u00cc", "u00ce", "u00cf", "u00f3", "u00f2", "u00f4", "u00f5", "u00f6", "u00d3", "u00d2", "u00d4", "u00d5", "u00d6", "u00fa", "u00f9", "u00fb", "u00fc", "u00da", "u00d9", "u00db", "u00e7", "u00c7", "u00f1", "u00d1", "u0026", "u0027"];
        $charIso = ["á", "à", "â", "ã", "ä", "Á", "À", "Â", "Ã", "Ä", "é", "è", "ê", "ê", "É", "È", "Ê", "Ë", "í", "ì", "î", "ï", "Í", "Ì", "Î", "Ï", "ó", "ò", "ô", "õ", "ö", "Ó", "Ò", "Ô", "Õ", "Ö", "ú", "ù", "û", "ü", "Ú", "Ù", "Û", "ç", "Ç", "ñ", "Ñ", "&", "\'"];

        return str_replace($charUtf8, $charIso, $data);
    }

    public function linkFast($module, $operation, $id = null)
    {
        if ($id) {
            $id = '&id='.$id;
        }

        return config('app.PATH_SYSTEM').$module.'&operation='.$operation.$id;
    }

    public function transformPhonesConfiguration($phones)
    {
        if ($phones) {
            $phonesArray = $phones['number'];

            $detailsArray = $operatorArray = null;

            if ($phones['details']) {
                $detailsArray = $phones['details'];
            }

            if ($phones['operator']) {
                $operatorArray = $phones['operator'];
            }

            $totalArray = count($phonesArray);

            for ($i = 0; $i < $totalArray; $i++) {
                $infoPhones[$i]['number'] = $phonesArray[$i];

                if ($detailsArray) {
                    $infoPhones[$i]['details'] = $detailsArray[$i];
                }
                else {
                    $infoPhones[$i]['details'] = null;
                }

                if ($operatorArray) {
                    $infoPhones[$i]['operator'] = $operatorArray[$i];
                }
                else {
                    $infoPhones[$i]['operator'] = null;
                }
            }

            return $infoPhones;
        }
    }

    public function transformEmailsConfiguration($emails)
    {
        if ($emails) {
            $emailsArray = $emails;

            if ($emailsArray['emails']) {
                $infoEmails = $emailsArray['emails'];
            }

            return $infoEmails;
        }
    }

    public function deleteFile($paths, $fileName)
    {
        if (is_array($paths)) {
            foreach ($paths as $keyPath => $valuePath) {
                if (is_dir($valuePath)) {
                    $file = $valuePath.'/'.$fileName;

                    if (file_exists($file)) {
                        unlink($file);
                    }

                    $explodeFileName = explode('.', $fileName);

                    $hashImage = $explodeFileName[0];

                    $file = $valuePath.'/'.$hashImage.'.webp';

                    if (file_exists($file)) {
                        unlink($file);
                    }
                }
            }
        }
    }

    public function urlComplet()
    {
        return config('app.BASE_URL') . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
    }

    public function generateUuid($key)
    {
        $uuid = Ramsey\Uuid\Uuid::uuid5(Ramsey\Uuid\Uuid::NAMESPACE_DNS, config('app.SECRET_KEY').$key);

        return $uuid->toString();
    }

    public function checkUuid($key, $uuidCompare)
    {
        $uuidGenerate = Ramsey\Uuid\Uuid::uuid5(Ramsey\Uuid\Uuid::NAMESPACE_DNS, config('app.SECRET_KEY').$key);

        if ($uuidCompare == $uuidGenerate) {
            return true;
        }
    }

    public function tableEmail($email, $classTd = 'text-left')
    {
        $email = $this->processString($email);

        return '<td class="'.$classTd.'"><p><a href="mailto:'.$email.'"><i class="far fa-envelope mr-2"></i>'.$email.'</a></p></td>';
    }

    public function getDownloadNumber($number)
    {
        if ($number) {
            return intval($number);
        }

        return '0';
    }
}
