<?php
// doopSites v1.9.7 - Última atualização 22/02/2023 16:20

class BreadcrumbDoop extends FunctionsDoop
{
    public $html = null;

    public $allModules = [];

    public $url = [];

    public $label = [
        'about' => 'Sobre o ',
        'extra' => 'Dados Extras',
        'manage' => 'Painel de Controle',
        'insert' => 'Cadastrar',
        'update' => 'Editar',
        'search' => 'Pesquisar',
        'view' => 'Visualizar',
        'export' => 'Exportar',
        'account' => 'Minha Conta',
        'feedback' => 'Feedback Módulos',
        'ibge' => 'IBGE',
        'support' => 'Suporte Técnico',
        'info' => 'Informações',
        'social' => 'Social',
        'central' => 'Painel de Controle',
        'toolbox' => 'ToolBox',
        'configForm' => 'Configuração de formulário',
        'dump' => 'Fazer Backup',
        'modulesInfo' => 'Dados do Módulo',
        'developer' => 'Desenvolvedor'
     ];

    public $path = null;

    public function __construct($modules)
    {
        parent::__construct('breadcrumb');

        $this->label['about'] = $this->label['about'].config('app.LABEL_SYSTEM_NAME');

        $this->allModules = $modules;

        if ($this->get('base')) {
            $this->url = explode('/', $this->get('base', 'array_explode'));
        }
    }

    public function setLabel($type, $info)
    {
        $this->label[$type] = $info;
    }

    public function viewBreadcrumb($viewLang)
    {
        $dataReturn = '<ol class="breadcrumb float-sm-right">';
        $dataReturn .= '<li class="breadcrumb-item">';
        $dataReturn .= '<a href="'.config('app.PATH_CMS_DASHBOARD').'"><i class="fas fa-tachometer-alt"></i></a>';
        $dataReturn .= '</li>';

        if ($viewLang) {
            $dataReturn .= '<li class="breadcrumb-item hidden-xs">';
            $dataReturn .= '<a href="'.config('app.PATH_CMS_DASHBOARD').'">'.\Treatment::string($viewLang).'</a>';
            $dataReturn .= '</li>';
        }
        if ($this->get('base')) {
            if (count($this->url) == 2) {
                 if (isset($this->label[$this->get('operation')]) && ($this->url[1] == 'configuration' || $this->url[1] == 'developer')) {
                    $dataReturn .= '<li class="breadcrumb-item active" title="'.$this->label[$this->get('operation')].'">'.$this->label[$this->get('operation')].'</li>';
                }
                else {
                    if ($this->url[1] != 'static') {
                        $dataReturn .= '<li class="breadcrumb-item"><a href="'.parent::pathlang(null, config('app.PATH_SYSTEM').$this->url[0].'/'.$this->url[1].'&operation='.$this->allModules[$this->url[1]]['start']).'" title="'.$this->getLabel($this->url[1]).'">'.$this->getLabel($this->url[1], 'label').'</a></li>';
                    }

                    if (array_key_exists($this->get('operation'), $this->label)) {
                        $dataReturn .= '<li class="breadcrumb-item active" title="'.$this->label[$this->get('operation')].'">'.$this->label[$this->get('operation')].'</li>';
                    }
                }
            }
            else {
                if (array_key_exists(1, $this->url) && $this->url[1] == 'ibge') {
                    $dataReturn .= '<li class="breadcrumb-item"><a href="'.parent::pathlang(null, config('app.PATH_SYSTEM').$this->url[0].'/'.$this->url[1].'/city&operation=manage').'" title="IBGE">IBGE</a></li>';
                }
                else if (array_key_exists(1, $this->url)) {
                    $dataReturn .= '<li class="breadcrumb-item"><a href="'.parent::pathlang(null, config('app.PATH_SYSTEM').$this->url[0].'/'.$this->url[1].'&operation=manage').'" title="'.$this->getLabel($this->url[1]).'">'.$this->getLabel($this->url[1], 'label').'</a></li>';
                }

                if (array_key_exists(1, $this->url)) {
                    $dataReturn .= '<li class="breadcrumb-item"><a href="'.parent::pathlang(null, config('app.PATH_SYSTEM').$this->url[0].'/'.$this->url[1].'/'.$this->url[2].'&operation=manage').'" title="'.$this->getLabel($this->url[1].'-'.$this->url[2]).'">'.$this->getLabel($this->url[1].'-'.$this->url[2], 'label').'</a></li>';
                }

                if ($this->get('module') && $this->get('operation') == 'modulesInfo') {
                    $dataReturn .= '<li class="breadcrumb-item"><a href="'.parent::pathlink($this->allModules[$this->get('module')]['folder'], $this->get('module')).'" title="'.$this->allModules[$this->get('module')]['title'].'">'.$this->allModules[$this->get('module')]['title'].'</a></li>';
                }

                $dataReturn .= '<li class="breadcrumb-item active" title="'.$this->label[$this->get('operation')].'">'.$this->label[$this->get('operation')].'</li>';
            }
        }
        else {
            $dataReturn .= '<li class="breadcrumb-item active" title="Dashboard">Dashboard</li>';
        }

        $dataReturn .= '</ol>';

        return $dataReturn;
    }

    public function getLabel($parameter, $type = 'title')
    {
        return $this->processString($this->allModules[$parameter][$type]);
    }
}
